const mongoose = require("mongoose");

const applicationSchema = new mongoose.Schema(
  {
    user: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "User",
      required: true,
    },
    job: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "Job",
      required: true,
    },
    status: {
      type: String,
      enum: ["pending", "shortlisted", "accepted", "rejected"],
      default: "pending",
    },
    resume: {
      type: String,
      required: true,
    },
  },
  {
    timestamps: true, // createdAt, updatedAt will be automatically added
  }
);

module.exports = mongoose.model("Application", applicationSchema);
