const User = require("../models/user.model");
const Application = require("../models/application.model");
const sendEmail = require("../utils/sendEmail");

exports.getProfile = async (req, res) => {
  try {
    const user = await User.findById(req.user.id).lean();
    const jobsApplied = await Application.find({ user: req.user.id }).lean();
    user.jobsApplied = jobsApplied;
    res.status(200).json({ user });
  } catch (error) {
    console.error(error);
    res.status(500).json({ message: error.message });
  }
};

exports.updateProfile = async (req, res) => {
  try {
    const user = await User.findByIdAndUpdate(req.user.id, req.body, {
      new: true,
    });
    res.status(200).json({ user });
  } catch (error) {
    console.error(error);
    res.status(500).json({ message: error.message });
  }
};
exports.getSavedJobs = async (req, res) => {
  try {
    const user = await User.findById(req.user.id).populate({
      path: "savedJobs.jobId",
      model: "Job",
      populate: {
        path: "createdBy",
        model: "User",
      },
    });

    const savedJobs = user.savedJobs;
    res.status(200).json({
      message: "Saved jobs fetched successfully",
      savedJobs,
    });
  } catch (error) {
    console.error("Error fetching saved jobs:", error);
    res.status(500).json({
      message: "Failed to fetch saved jobs",
      error: error.message,
    });
  }
};

exports.getAppliedJobs = async (req, res) => {
  try {
    const appliedJobs = await Application.find({
      user: req.user.id,
    }).populate({
      path: "job",
      model: "Job",
      populate: {
        path: "createdBy",
        model: "User",
      },
    });
    res.status(200).json({
      message: "Applied jobs fetched successfully",
      appliedJobs,
    });
  } catch (error) {
    console.error("Error fetching applied jobs:", error);
    res.status(500).json({
      message: "Failed to fetch applied jobs",
      error: error.message,
    });
  }
};

exports.sendEmail = async (req, res) => {
  try {
    const { email, subject, message } = req.body;
    // return res.status(200).json({ email, subject, message });

    await sendEmail("jobtalk2025@gmail.com", subject, message, email);

    res.status(200).json({
      success: true,
      message: "Email sent successfully",
    });
  } catch (error) {
    console.error("Error sending email:", error);
    res.status(500).json({
      success: false,
      message: "Failed to send email",
    });
  }
};
