// user.model.js

const mongoose = require("mongoose");

const userSchema = new mongoose.Schema(
  {
    firstName: { type: String, required: true },
    lastName: { type: String, required: true },
    profileImage: { type: String, default: "" },
    about: { type: String, default: "" },
    email: { type: String, required: true, unique: true },
    password: { type: String, required: true },
    phone: { type: String, required: true },
    state: { type: String, required: false },
    city: { type: String, required: false },

    skills: { type: [String], default: [] },
    experience: { type: String },
    education: { type: String },
    resume: { type: String, default: null },

    year: { type: String },
    cgpa: { type: Number },
    status: {
      type: String,
      enum: ["Placed", "Not Placed", "On Campus", "Off Campus", "In Process"],
    },
    company: { type: mongoose.Schema.Types.ObjectId, ref: "Job" },
    package: { type: String },
    // appliedJobs: [
    //   {
    //     jobId: {
    //       type: mongoose.Schema.Types.ObjectId,
    //       ref: "Job",
    //       required: true,
    //     },
    //     appliedAt: {
    //       type: Date,
    //       default: Date.now,
    //     },
    //   },
    // ],
    savedJobs: [
      {
        jobId: {
          type: mongoose.Schema.Types.ObjectId,
          ref: "Job",
          required: true,
        },
        savedAt: {
          type: Date,
          default: Date.now,
        },
      },
    ],

    college: { type: String },
    department: { type: String },

    role: {
      type: String,
      enum: ["user", "TPO", "employer", "admin"],
      default: "user",
    },

    companyName: { type: String, default: "" },
    companyLogo: { type: String, default: "" },
    companyDescription: { type: String, default: "" },
  },
  {
    timestamps: true, // Auto createdAt and updatedAt
  }
);

const User = mongoose.model("User", userSchema);

module.exports = User;
