const express = require("express");
const router = express.Router();
const {
  createJob,
  updateJob,
  deleteJob,
  applyJob,
  toggleSaveJob,
  getJobsByCategory,
  getJobs,
  getFeaturedJobs,
  getJobById,
} = require("../controllers/job.controller");

const authenticateToken = require("../utils/authenticateToken");
router.post("/employer/create-job", authenticateToken, createJob);
router.put("/employer/update-job/:id", authenticateToken, updateJob);
router.delete("/employer/delete-job/:id", authenticateToken, deleteJob);

router.post("/apply-job/:id", authenticateToken, applyJob);
router.post("/toggle-save-job/:id", authenticateToken, toggleSaveJob);
router.get("/category/:category", getJobsByCategory);
router.get("/search", getJobs);
router.get("/featured-jobs", getFeaturedJobs);
router.get("/:id", getJobById);

module.exports = router;
